/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.BlockOptionalMeta;
import baritone.api.utils.accessor.IItemStack;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public class BlockOptionalMetaLookup {
    private final ImmutableSet<class_2248> blockSet;
    private final ImmutableSet<class_2680> blockStateSet;
    private final ImmutableSet<Integer> stackHashes;
    private final BlockOptionalMeta[] boms;

    public BlockOptionalMetaLookup(BlockOptionalMeta ... blockOptionalMetaArray) {
        this.boms = blockOptionalMetaArray;
        HashSet<class_2248> hashSet = new HashSet<class_2248>();
        HashSet<class_2680> hashSet2 = new HashSet<class_2680>();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        for (BlockOptionalMeta blockOptionalMeta : blockOptionalMetaArray) {
            hashSet.add(blockOptionalMeta.getBlock());
            hashSet2.addAll(blockOptionalMeta.getAllBlockStates());
            hashSet3.addAll(blockOptionalMeta.stackHashes());
        }
        this.blockSet = ImmutableSet.copyOf(hashSet);
        this.blockStateSet = ImmutableSet.copyOf(hashSet2);
        this.stackHashes = ImmutableSet.copyOf(hashSet3);
    }

    public BlockOptionalMetaLookup(class_2248 ... class_2248Array) {
        this((BlockOptionalMeta[])Stream.of(class_2248Array).map(BlockOptionalMeta::new).toArray(BlockOptionalMeta[]::new));
    }

    public BlockOptionalMetaLookup(List<class_2248> list) {
        this((BlockOptionalMeta[])list.stream().map(BlockOptionalMeta::new).toArray(BlockOptionalMeta[]::new));
    }

    public BlockOptionalMetaLookup(String ... stringArray) {
        this((BlockOptionalMeta[])Stream.of(stringArray).map(BlockOptionalMeta::new).toArray(BlockOptionalMeta[]::new));
    }

    public boolean has(class_2248 class_22482) {
        return this.blockSet.contains((Object)class_22482);
    }

    public boolean has(class_2680 class_26802) {
        return this.blockStateSet.contains((Object)class_26802);
    }

    public boolean has(class_1799 class_17992) {
        int n = ((IItemStack)class_17992).getBaritoneHash() - class_17992.method_7919();
        return this.stackHashes.contains((Object)n);
    }

    public List<BlockOptionalMeta> blocks() {
        return Arrays.asList(this.boms);
    }

    public String toString() {
        return String.format("BlockOptionalMetaLookup{%s}", Arrays.toString(this.boms));
    }
}

